<?php
class ClickaTell 
{
	private $_authToken;
	private $_sendSmsUrl = "https://api.clickatell.com/rest/message";
	private $_accountBalanceUrl = "https://api.clickatell.com/rest/account/balance";
	
	public function __construct($auth_token)
	{
		$this->_authToken = $auth_token;
	}
	
	public function getMessageStatus($message_id)
	{
		return $this->curl($this->_sendSmsUrl . '/' . $message_id);
	}
	
	public function getBalance()
	{
		return $this->curl($this->_accountBalanceUrl);
	}
	
	public function sendSms($data)
	{
		return $this->curl($this->_sendSmsUrl, $data);
	}
	
	public function curl($url_to, $postData = "")
	{
		$http_header[] = "X-Version: 1";
		$http_header[] = "Accept: application/json";
		$http_header[] = "Authorization: Bearer " . $this->_authToken;
		
		if ($postData != '')
			$http_header[] = "Content-Type: application/json";
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url_to);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
		
		if ($postData != '')
		{
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
		}
		
		$result = curl_exec ($ch);
		curl_close ($ch);
		
		return $result;
	}
}

?>

