<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ini_set('log_errors', 'On');

require_once ("db/db.php");
require_once ("sms/ClickaTell.class.php");
require_once ("common/constants.php");

global $db;
$db = connect_to_db();
if (!$db) exit;

echo send_sms(1111, 2222, '+212600000601', 'Bonjour');
exit;

$query = "select key_name, key_value from parameters where key_name in ('temperature_alert', 'humidity_alert', 'operability_alert')";
$result = $db->query($query);
$ar_params = array();
while ($row_params = $result->fetch_array(MYSQLI_ASSOC))
{
	$ar_params[$row_params['key_name']] = json_decode($row_params['key_value'], true);
}

// Chercher les alertes declenchees --------------------------------------------------------------- Start
$bigdata = false;
$bigdata_db_index = 0;
$timezone = '';
$ar_alerts_on = array();
global $ar_logs;
$ar_logs = array();
$customer_id = 0;
$query = "select al.*, lo.location_name, bx.box_name, sr.sensor_name, sr.temp_unit, lo.timezone, cu.customer_id, cu.company, cu.bigdata_db_index
				from alertes al, sensors sr, boxes bx, locations lo, customers cu
				where al.alert_sent = 0 
				and al.status = 1 and al.sensor_id = sr.sensor_id and sr.active = 1
				and sr.box_id = bx.box_id and bx.active = 1
				and bx.location_id = lo.location_id and lo.customer_id = cu.customer_id and cu.status = 1
				order by cu.bigdata_db_index, lo.timezone";
$result = $db->query($query);
while ($row = $result->fetch_array(MYSQLI_ASSOC))
{
	if ($bigdata_db_index != $row['bigdata_db_index'])
	{
		if ($bigdata) $bigdata->close(); // close previous db
		$bigdata = connect_to_db($row['bigdata_db_index']);
		if (!$bigdata) continue;
		$bigdata_db_index = $row['bigdata_db_index'];
	}
	
	if ($timezone != $row['timezone'])
	{
		$timezone = $row['timezone'];
		date_default_timezone_set($row['timezone']);
	}
	
	/*if (!isset($ar_logs[$row['customer_id']]))
	{
		$ar_logs[$row['customer_id']] = dirname(__FILE__) . "/logs/alerts_{$row['customer_id']}.log";
		ini_set('error_log', dirname(__FILE__) . "/logs/alerts_{$row['customer_id']}.log");
		//error_log('-------------------------------------------', 0, $ar_logs[$row['customer_id']]);
	}*/
	if ($customer_id != $row['customer_id'])
	{
		$customer_id = $row['customer_id'];
		$ar_logs[$customer_id] = dirname(__FILE__) . "/logs/alerts_{$customer_id}.log";
		ini_set('error_log', dirname(__FILE__) . "/logs/alerts_{$customer_id}.log");
	}
		
	$date_now = date('Y-m-d H:i:s');
	
	if ($row['authorized_time'] > MAX_BACK_TIME) $row['authorized_time'] = MAX_BACK_TIME;
	
	$captured_value = $captured_date = '';
	$alert_nature = 1; // Alerte declenchee
		
	if ($row['min_value'] == NULL && $row['max_value'] == NULL) // cas de probleme inconnu, a detecter par la suite (wifi, electricite, boitier, arduino, ...)
	{
		if ($row['authorized_time'] < DEFAULT_BACK_TIME) $back_time = DEFAULT_BACK_TIME;
		else $back_time = $row['authorized_time'];		
		
		$query = "select capture_id from captured_data where sensor_id = '{$row['sensor_id']}'
						and capture_date >= date_sub('$date_now', interval $back_time minute) limit 1";
    	$result_capture = $bigdata->query($query);
		
		if ($result_capture->num_rows == 0)
		{
			$send_alert = true;
			$alert_nature = 3; // Capteur inoperable
			$captured_value = '-';
			$captured_date = '-';
		}
		else $send_alert = false;
	}
	else if ($row['authorized_time'] > 0)
	{
		$back_time = $row['authorized_time'];
		
		$query = "select capture_value, capture_date from captured_data where sensor_id = '{$row['sensor_id']}' and capture_type = '{$row['alert_type']}' and status = 1
						and capture_date >= date_sub('$date_now', interval $back_time minute) order by capture_date asc"; // asc pour avoir la derniere valeur
		$result_capture = $bigdata->query($query);
		
		$min_value = ($row['min_value'] != NULL) ? $row['min_value'] : -9999999;
		$max_value = ($row['max_value'] != NULL) ? $row['max_value'] : +9999999;
		
		$send_alert = false;
		if ($result_capture->num_rows > 0)
		{
			$send_alert = true;
			while ($row_capture = $result_capture->fetch_array(MYSQLI_ASSOC))
			{
				$captured_value = $row_capture['capture_value'];
				$captured_date = date("Y-m-d H:i", strtotime($row_capture['capture_date']));
				
				if ($row_capture['capture_value'] < $min_value || $row_capture['capture_value'] > $max_value)
				{
					$send_alert = false;
					break;
				}
			}
		}
	}
	else // authorized_time = 0, donc envoyer alerte a la premiere APPARITION
	{
		$back_time = DEFAULT_BACK_TIME;
		
		$query = "select capture_value, capture_date from captured_data where sensor_id = '{$row['sensor_id']}' and capture_type = '{$row['alert_type']}' and status = 1
						and capture_date >= date_sub('$date_now', interval $back_time minute) order by capture_date asc";
		$result_capture = $bigdata->query($query);
		
		$min_value = ($row['min_value'] != NULL) ? $row['min_value'] : -9999999;
		$max_value = ($row['max_value'] != NULL) ? $row['max_value'] : +9999999;
		
		$send_alert = false;
		if ($result_capture->num_rows > 0)
		{
			while ($row_capture = $result_capture->fetch_array(MYSQLI_ASSOC))
			{
				if ($row_capture['capture_value'] >= $min_value && $row_capture['capture_value'] <= $max_value)
				{
					$captured_value = $row_capture['capture_value'];
					$captured_date = date("Y-m-d H:i", strtotime($row_capture['capture_date']));
					$send_alert = true;
					break;
				}
			}
		}
	}
	
	if ($send_alert)
	{
		//$alert_on_id = send_alert('alert_on', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
		//if ($alert_on_id > 0) $ar_alerts_on[] = $alert_on_id;		
		if ($alert_nature == 3) // Capteur inoperable, alerte a envoyer au support
		{
			if ($customer_id == 10) // Viandes El Byad
			{
				$alert_on_id = send_alert('alert_on', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
				if ($alert_on_id > 0) $ar_alerts_on[] = $alert_on_id;
			}
			else
			{
				send_alert_to_support('alert_on', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
				$ar_alerts_on[] = $row['alert_id'];
			}
		}
		else
		{
			$alert_on_id = send_alert('alert_on', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
			if ($alert_on_id > 0) $ar_alerts_on[] = $alert_on_id;
		}
	}
}
if ($bigdata) $bigdata->close();
// Chercher les alertes declenchees --------------------------------------------------------------- End

// Chercher les alertes disparues ----------------------------------------------------------------- Start
$bigdata = false;
$bigdata_db_index = 0;
$timezone = '';
$ar_alerts_off = array();
$customer_id = 0;
$query = "select al.*, lo.location_name, bx.box_name, sr.sensor_name, sr.temp_unit, lo.timezone, cu.customer_id, cu.company, cu.bigdata_db_index
				from alertes al, sensors sr, boxes bx, locations lo, customers cu
				where al.alert_sent = 1 
				and al.status = 1 and al.sensor_id = sr.sensor_id and sr.active = 1
				and sr.box_id = bx.box_id and bx.active = 1
				and bx.location_id = lo.location_id and lo.customer_id = cu.customer_id and cu.status = 1
				order by cu.bigdata_db_index, lo.timezone";
$result = $db->query($query);
while ($row = $result->fetch_array(MYSQLI_ASSOC))
{
	if ($bigdata_db_index != $row['bigdata_db_index'])
	{
		if ($bigdata) $bigdata->close(); // close previous db
		$bigdata = connect_to_db($row['bigdata_db_index']);
		if (!$bigdata) continue;
		$bigdata_db_index = $row['bigdata_db_index'];
	}
	
	if ($timezone != $row['timezone'])
	{
		$timezone = $row['timezone'];
		date_default_timezone_set($row['timezone']);
	}
	
	/*if (!isset($ar_logs[$row['customer_id']]))
	{
		$ar_logs[$row['customer_id']] = dirname(__FILE__) . "/logs/alerts_{$row['customer_id']}.log";
		ini_set('error_log', dirname(__FILE__) . "/logs/alerts_{$row['customer_id']}.log");
		//error_log('-------------------------------------------', 0, $ar_logs[$row['customer_id']]);
	}*/
	if ($customer_id != $row['customer_id'])
	{
		$customer_id = $row['customer_id'];
		$ar_logs[$customer_id] = dirname(__FILE__) . "/logs/alerts_{$customer_id}.log";
		ini_set('error_log', dirname(__FILE__) . "/logs/alerts_{$customer_id}.log");
	}
	
	$date_now = date('Y-m-d H:i:s');
	
	if ($row['authorized_time'] > MAX_BACK_TIME) $row['authorized_time'] = MAX_BACK_TIME;
	
	$captured_value = $captured_date = '';
	$alert_nature = 2; // Alerte disparue
		
	if ($row['min_value'] == NULL && $row['max_value'] == NULL) // cas de probleme inconnu, mais il a disparu
	{
		if ($row['authorized_time'] < DEFAULT_BACK_TIME) $back_time = DEFAULT_BACK_TIME;
		else $back_time = $row['authorized_time'];
		
		$query = "select capture_value, capture_date from captured_data where sensor_id = '{$row['sensor_id']}'
						and capture_date >= date_sub('$date_now', interval $back_time minute) limit 1";
    	$result_capture = $bigdata->query($query);
		if ($result_capture->num_rows == 0) $send_alert = false;
		else
		{
			$row_capture = $result_capture->fetch_array(MYSQLI_ASSOC);
			$captured_value = $row_capture['capture_value'];
			$captured_date = date("Y-m-d H:i", strtotime($row_capture['capture_date']));
			$send_alert = true;
			$alert_nature = 4; // Capteur devenu operable
		}
	}
	else
	{
		if ($row['authorized_time'] > 0) $back_time = $row['authorized_time'];
		else $back_time = DEFAULT_BACK_TIME; // authorized_time = 0, donc envoyer message a la premiere DISPARITION
		
		$query = "select capture_value, capture_date from captured_data where sensor_id = '{$row['sensor_id']}' and capture_type = '{$row['alert_type']}' and status = 1
						and capture_date >= date_sub('$date_now', interval $back_time minute) order by capture_date asc"; // asc pour avoir la derniere valeur
		$result_capture = $bigdata->query($query);
		
		$min_value = ($row['min_value'] != NULL) ? $row['min_value'] : -9999999;
		$max_value = ($row['max_value'] != NULL) ? $row['max_value'] : +9999999;
		
		$send_alert = false;
		if ($result_capture->num_rows > 0)
		{
			while ($row_capture = $result_capture->fetch_array(MYSQLI_ASSOC))
			{
				if ($row_capture['capture_value'] < $min_value || $row_capture['capture_value'] > $max_value)
				{
					$captured_value = $row_capture['capture_value'];
					$captured_date = date("Y-m-d H:i", strtotime($row_capture['capture_date']));
					$send_alert = true;
					break;
				}
			}
		}
	}
	
	if ($send_alert)
	{
		//$alert_off_id = send_alert('alert_off', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
		//if ($alert_off_id > 0) $ar_alerts_off[] = $alert_off_id;		
		if ($alert_nature == 4) // Capteur devenu operable, notif a envoyer au support
		{
			if ($customer_id == 10) // Viandes El Byad
			{
				$alert_off_id = send_alert('alert_off', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
				if ($alert_off_id > 0) $ar_alerts_off[] = $alert_off_id;
			}
			else
			{
				send_alert_to_support('alert_off', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
				$ar_alerts_off[] = $row['alert_id'];
			}
		}
		else
		{
			$alert_off_id = send_alert('alert_off', $row, $ar_params, $alert_nature, $captured_value, $captured_date);
			if ($alert_off_id > 0) $ar_alerts_off[] = $alert_off_id;
		}
	}
}
if ($bigdata) $bigdata->close();
// Chercher les alertes disparues ----------------------------------------------------------------- End

// Update alertes sent status --------------------------------------------------------------------- Start
$date_now = date('Y-m-d H:i:s');
if (count($ar_alerts_on) > 0)
{
	$alerts_on = join(",", $ar_alerts_on);
	$query = "update alertes set alert_sent = 1, send_date = '$date_now' where alert_id in ($alerts_on)";
	$db->query($query);
}
if (count($ar_alerts_off) > 0)
{
	$alerts_off = join(",", $ar_alerts_off);
	$query = "update alertes set alert_sent = 0, send_date = '$date_now' where alert_id in ($alerts_off)";
	$db->query($query);
}
// Update alertes sent status --------------------------------------------------------------------- End

$db->close();

function send_alert($alert_on_off, $row, $ar_params, $alert_nature, $captured_value, $captured_date)
{
	global $db;
	
	/*$query = "select au.*, us.email as email_address, us.phone, us.push_token, pu.language
				from alertes_users au, users us
				LEFT JOIN params_users pu ON (pu.user_id = us.user_id)
				where au.alert_id = '{$row['alert_id']}' and au.user_id = us.user_id and us.status = 1";*/
	$query = "select au.*, us.email as email_address, us.phone, pu.language
				from alertes_users au, users us
				LEFT JOIN params_users pu ON (pu.user_id = us.user_id)
				where au.alert_id = '{$row['alert_id']}' and au.user_id = us.user_id and us.status = 1";
	$result_users = $db->query($query);
	
	if ($result_users->num_rows > 0)
	{
		$date_now = date('Y-m-d H:i:s');
		
		$measure_unit = '';
		if ($row['alert_type'] == 0) $alert_type = 'operability_alert';
		else if ($row['alert_type'] == 2)
		{
			$alert_type = 'humidity_alert';
			$measure_unit = '%';
		}
		else
		{
			$alert_type = 'temperature_alert';
			if ($row['temp_unit'] == 1) $measure_unit = '°C';
			else if ($row['temp_unit'] == 2) $measure_unit = '°F';
			else if ($row['temp_unit'] == 3) $measure_unit = '°K';
		}
		
		if ($row['authorized_time'] % 60 == 0) $authorized_time = ($row['authorized_time'] / 60) . ' hr';
		else $authorized_time = $row['authorized_time'] . ' min';
		
		$min_value = ($row['min_value'] != NULL) ? $row['min_value'] : '-';
		$max_value = ($row['max_value'] != NULL) ? $row['max_value'] : '-';
		
		while ($row_users = $result_users->fetch_array(MYSQLI_ASSOC))
		{
			//if (isset($row_users['language']) && $row_users['language'] != NULL) $language = $row_users['language'];
			//else $language = 'fr';
			$language = $row_users['language'];
			if ($language == '') $language = 'fr';
			
			$sms_content_orig = $ar_params[$alert_type][$language][$alert_on_off]['sms_message'];
			$email_subject_orig = $ar_params[$alert_type][$language][$alert_on_off]['email_sujet'];
			$email_content_orig = $ar_params[$alert_type][$language][$alert_on_off]['email_message'];
			$push_subject_orig = $ar_params[$alert_type][$language][$alert_on_off]['push_sujet'];
			$push_content_orig = $ar_params[$alert_type][$language][$alert_on_off]['push_message'];
			
			$sms_content = $email_content = $push_content = '';
			$sms_phone = $email_subject = $email_address = $push_subject = '';
			$sms_charge = 0;
			
			$ar_source = array('[VALUE]', '[DATE]', '[LOCATION]', '[SENSOR]', '[VALUE_MIN]', '[VALUE_MAX]', '[AUTHORIZED]');
			$ar_dest = array($captured_value . $measure_unit, $captured_date, $row['location_name'], $row['sensor_name'], $min_value, $max_value, $authorized_time);
							
			if ($row_users['email'])
			{
				$email_address = $row_users['email_address'];
				$email_subject = str_replace($ar_source, $ar_dest, $email_subject_orig);
				$email_content = str_replace($ar_source, $ar_dest, $email_content_orig);
				
				send_mail($email_address, $row['company'] . ' : ' . $email_subject, $email_content);
				/*if ($alert_nature == 3 || $alert_nature == 4) // m'envoyer seulement cette alerte d'operabilite, temporairement
					send_mail('amazouzi@njt-group.com', $email_subject, $email_content);
				else send_mail($email_address, $email_subject, $email_content);*/
			}
			
			//if ($row_users['sms'] && $alert_nature != 3 && $alert_nature != 4) // ne pas envoyer l'alerte d'operabilite aux clients, temporairement
			if ($row_users['sms'])
			{
				//$sms_phone = $row_users['phone'];
				//$sms_content = str_replace($ar_source, $ar_dest, $sms_content_orig);
								
				if (can_send_sms($row['customer_id'], $date_now))
				{
					$sms_phone = $row_users['phone'];
					$sms_content = str_replace($ar_source, $ar_dest, $sms_content_orig);
					$sms_charge = send_sms($row['customer_id'], $row_users['user_id'], $sms_phone, $sms_content);
					if ($sms_charge > 0)
					{
						$query = "update customers_balance set sms_count = sms_count + $sms_charge where customer_id = '{$row['customer_id']}'";
						$db->query($query);
					}
				}
			}
			if ($row_users['push'])
			{	
				$push_subject = str_replace($ar_source, $ar_dest, $push_subject_orig);
				$push_content = str_replace($ar_source, $ar_dest, $push_content_orig);
			}
						
			$alert_nature = $db->real_escape_string($alert_nature);
			$sms_content = $db->real_escape_string($sms_content);
			$email_content = $db->real_escape_string($email_content);
			$email_subject = $db->real_escape_string($email_subject);
			$push_content = $db->real_escape_string($push_content);
			$push_subject = $db->real_escape_string($push_subject);
			$query = "insert into alertes_history (alert_id, user_id, alert_nature, alert_value, alert_date, sms_content, sms_phone, sms_charge, email_content, email_subject, email_address, push_content, push_subject, history_date) values
						('{$row['alert_id']}', '{$row_users['user_id']}', '$alert_nature', '$captured_value', '$captured_date', '$sms_content', '$sms_phone', '$sms_charge', '$email_content', '$email_subject', '$email_address', '$push_content', '$push_subject', '$date_now')";
			$db->query($query);
			$alert_history_id = $db->insert_id;
			
			if ($row_users['push'])
			{
				//send_push($row['customer_id'], $row_users['user_id'], $row_users['push_token'], $alert_history_id, $push_subject, $push_content, $language);
				send_push($row['customer_id'], $row_users['user_id'], $alert_history_id, $push_subject, $push_content, $language);
			}
		}
		
		return $row['alert_id'];
	}
	else return 0;
}

function send_alert_to_support($alert_on_off, $row, $ar_params, $alert_nature, $captured_value, $captured_date)
{
	$measure_unit = '';
	if ($row['alert_type'] == 0) $alert_type = 'operability_alert';
	else if ($row['alert_type'] == 2)
	{
		$alert_type = 'humidity_alert';
		$measure_unit = '%';
	}
	else
	{
		$alert_type = 'temperature_alert';
		if ($row['temp_unit'] == 1) $measure_unit = '°C';
		else if ($row['temp_unit'] == 2) $measure_unit = '°F';
		else if ($row['temp_unit'] == 3) $measure_unit = '°K';
	}
	
	if ($row['authorized_time'] % 60 == 0) $authorized_time = ($row['authorized_time'] / 60) . ' hr';
	else $authorized_time = $row['authorized_time'] . ' min';
	
	$min_value = ($row['min_value'] != NULL) ? $row['min_value'] : '-';
	$max_value = ($row['max_value'] != NULL) ? $row['max_value'] : '-';
	
	$language = 'fr';
	$email_subject_orig = $ar_params[$alert_type][$language][$alert_on_off]['email_sujet'];
	$email_content_orig = $ar_params[$alert_type][$language][$alert_on_off]['email_message'];
	
	$ar_source = array('[VALUE]', '[DATE]', '[LOCATION]', '[SENSOR]', '[VALUE_MIN]', '[VALUE_MAX]', '[AUTHORIZED]');
	$ar_dest = array($captured_value . $measure_unit, $captured_date, $row['location_name'], $row['sensor_name'], $min_value, $max_value, $authorized_time);
					
	$email_subject = str_replace($ar_source, $ar_dest, $email_subject_orig);
	$email_content = str_replace($ar_source, $ar_dest, $email_content_orig);				
	mail('amazouzi@njt-group.com', $row['company'] . ' : ' . $email_subject, $email_content);
}

function send_sms($customer_id, $user_id, $phone, $body)
{
	global $ar_logs;
	
	$body = str_replace('°', ' ', $body); // probleme de degree
	$body = str_replace(array("\r\n", "<br>", "<br />", "<br/>"), "\n", $body);
	
	$ch = curl_init('https://www.radeef.ma/send_sms.php');
	$post = array('phone_number' => $phone, 'message' => $body);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	$result = curl_exec($ch);
	curl_close($ch);
	echo $result;
	if (strstr($result, '<StatusCode>201</StatusCode>')) return 1;
	else return 0;
}

function send_sms_old_ClickaTell($customer_id, $user_id, $phone, $body)
{
	global $ar_logs;
	
	error_log("customer_id : $customer_id", 0, $ar_logs[$customer_id]);
	error_log("user_id : $user_id", 0, $ar_logs[$customer_id]);
	error_log("phone : $phone", 0, $ar_logs[$customer_id]);
	error_log("body before : $body", 0, $ar_logs[$customer_id]);
	
	$ClickaTell = new ClickaTell(SMS_CLICKATELL_API_AUTH_TOKEN);
	
	$body = str_replace('°', ' ', $body); // probleme de degree
	
	//$body = preg_replace('/u([\da-fA-F]{4})/', '&#x\1;', $body);
	$body = str_replace(array("\r\n", "<br>", "<br />", "<br/>"), "\n", $body);
	
	error_log("body after : $body", 0, $ar_logs[$customer_id]);
			
	$postData = json_encode(array("text" => $body, "to" => array($phone)));
	error_log("postData : $postData", 0, $ar_logs[$customer_id]);
	
	//$data = json_decode($ClickaTell->sendSms($postData), true);
	$result_sms = $ClickaTell->sendSms($postData);
	error_log("response sms : $result_sms", 0, $ar_logs[$customer_id]);
	
	$data = json_decode($result_sms, true);
	//print_r($data);
	if (isset($data['data']['message'][0]['accepted']) && $data['data']['message'][0]['accepted'])
	{	
		$data = json_decode($ClickaTell->getMessageStatus($data['data']['message'][0]['apiMessageId']), true);		
		//print_r($data);
		if (isset($data['data']['charge']) && is_numeric($data['data']['charge'])) return $data['data']['charge'];
		else return -1; // must check what happened here !
	}
	else return 0;
}

function send_mail($email, $subject, $body)
{
	mail($email, $subject, $body);
	mail('abdellah@nejmatech.com', $subject, $body);
}

//function send_push($customer_id, $user_id, $token, $alert_history_id, $subject, $body, $language)
function send_push($customer_id, $user_id, $alert_history_id, $subject, $body, $language)
{
	//if ($token == '') return;
	
	global $db;
	global $ar_logs;
	
	$ar_phone_token = array();
		
	error_log("user_id : $user_id", 0, $ar_logs[$customer_id]);
	
	$query = "select push_token from users_push_token where user_id = '$user_id'";
	error_log("query : $query", 0, $ar_logs[$customer_id]);
	$result_tokens = $db->query($query);
	while ($row_tokens = $result_tokens->fetch_array(MYSQLI_ASSOC))
	{
		$ar_phone_token[] = $row_tokens['push_token'];
	}
	if (count($ar_phone_token) == 0)
	{
		error_log("response push : no token yet", 0, $ar_logs[$customer_id]);
		return;
	}
	
	$tokens = join(",", $ar_phone_token);
	error_log("tokens : $tokens", 0, $ar_logs[$customer_id]);
	
	error_log("language : $language", 0, $ar_logs[$customer_id]);
	
	$body = str_replace(array('\r\n', '<br>', '<br />', '<br/>'), "\n", $body);
	$content = array('en' => $body, $language => $body);
	$headings = array('en' => $subject, $language => $subject);	
	$fields = array(
		'include_player_ids' => $ar_phone_token,
		'contents' => $content,
		'headings' => $headings,
		'android_group' => 'THERMODITY',
		'android_group_message' => array('en' => 'THERMODITY ($[notif_count])', $language => 'THERMODITY ($[notif_count])'),
		'data' => array('alertId' => $alert_history_id),
		'small_icon' => 'mipmap/icon'
	);	
	$fields['app_id'] = ONE_SIGNAL_API_ID;		
	$fields = json_encode($fields);
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8', 'Authorization: Basic ' . ONE_SIGNAL_AUTHORIZATION));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	curl_setopt($ch, CURLOPT_HEADER, FALSE);
	curl_setopt($ch, CURLOPT_POST, TRUE);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);	
	$response = curl_exec($ch);	
	curl_close($ch);
	
	//echo $response;
	error_log("response push : $response", 0, $ar_logs[$customer_id]);
}

function can_send_sms($customer_id, $date_now) // Envoyer un rappel pour recharger son solde
{
	// ici !!!
	if ($customer_id != 10) return false; // Viandes El Byad
	
	global $db;
	
	$query = "select cb.sms_count, pc.pack_sms, pc.sms_reminder, pc.sms_reminder_date from customers_balance cb, params_customers pc
				where cb.customer_id = '$customer_id' and cb.customer_id = pc.customer_id";
    $result = $db->query($query);
	if ($result->num_rows > 0)
	{
		$row = $result->fetch_array(MYSQLI_ASSOC);
		$sms_balance = $row['pack_sms'] - $row['sms_count'];
		
		if ($sms_balance <= 0) return false;
		else
		{
			if ($sms_balance <= $row['sms_reminder'] && $row['sms_reminder_date'] == NULL)
			{
				$query = "update params_customers set sms_reminder_date = '$date_now' where customer_id = '$customer_id'";
				$db->query($query);
				
				$query = "select email from users where customer_id = '$customer_id' and admin = 1";
				$result = $db->query($query);
				$row_user = $result->fetch_array(MYSQLI_ASSOC);
				
				$subject = 'THERMODITY : Balance SMS Insuffisante - ' . $customer_id;
				$body = "Bonjour,\n\nVotre balance actuelle est arrivée au seuil de votre balance de rappel : {$row['sms_reminder']} SMS.\n\n";
				$body .= "Cordialement,";				
				//send_mail($row_user['email'], $subject, $body);
				send_mail('abdellah@nejmatech.com', $subject, $body); // envoyer seulement a mon email
			}
			
			return true;
		}
	}
	else return false;
}
?>